package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aAplicacionInvocante;
import com.ejie.ab18a.utils.Utilidades;

/**
 * Ab18a03s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aAplicacionInvocanteDaoImpl implements Ab18aAplicacionInvocanteDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aAplicacionInvocante> rwMap = new RowMapper<Ab18aAplicacionInvocante>() {
		public Ab18aAplicacionInvocante mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aAplicacionInvocante(resultSet.getInt("T03IDAPLICACION"), resultSet.getInt("T03MODORECEPCION"),
					resultSet.getString("T03DESCES"), resultSet.getString("T03DESCEU"));
		}
	};

	private RowMapper<Ab18aAplicacionInvocante> rwMapPK = new RowMapper<Ab18aAplicacionInvocante>() {
		public Ab18aAplicacionInvocante mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aAplicacionInvocante(resultSet.getInt("T03IDAPLICACION"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aAplicacionInvocante>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aAplicacionInvocante>>() {
		public JerarquiaDto<Ab18aAplicacionInvocante> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Ab18aAplicacionInvocante ab18a03s00 = new Ab18aAplicacionInvocante(resultSet.getInt("T03IDAPLICACION"),
					resultSet.getInt("T03MODORECEPCION"), resultSet.getString("T03DESCES"), resultSet.getString("T03DESCEU"));

			JerarquiaDto<Ab18aAplicacionInvocante> jerarquia = new JerarquiaDto<Ab18aAplicacionInvocante>();
			jerarquia.setModel(ab18a03s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * @param secuencia
	 *            String
	 * @return String
	 * @throws Exception
	 *             the exception
	 */
	public int getNextSequenceValue(String secuencia) throws Exception {
		Integer sequenceValue = -1;
		try {
			String query = "SELECT " + secuencia + ".NEXTVAL FROM DUAL";
			sequenceValue = this.jdbcTemplate.queryForInt(query);
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}
		return sequenceValue;
	}

	/**
	 * Inserts a single row in the Ab18a03s00 table.
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00
	 * @return Ab18a03s00
	 * @throws Exception
	 * @throws DataAccessException
	 */
	public Ab18aAplicacionInvocante add(Ab18aAplicacionInvocante ab18a03s00) throws DataAccessException, Exception {
		String query = "INSERT INTO AB18A03S00 (T03_ID_APLICACION, T03_MODO_RECEPCION, T03_DESC_ES, T03_DESC_EU) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, this.getNextSequenceValue("SQAB18A03"), ab18a03s00.getT03ModoRecepcion(), ab18a03s00.getT03DescEs(),
				ab18a03s00.getT03DescEu());
		return ab18a03s00;
	}

	/**
	 * Updates a single row in the Ab18a03s00 table.
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00
	 * @return Ab18a03s00
	 */
	public Ab18aAplicacionInvocante update(Ab18aAplicacionInvocante ab18a03s00) {
		String query = "UPDATE AB18A03S00 SET T03_MODO_RECEPCION=?, T03_DESC_ES=?, T03_DESC_EU=? WHERE T03_ID_APLICACION=?";
		this.jdbcTemplate.update(query, ab18a03s00.getT03ModoRecepcion(), ab18a03s00.getT03DescEs(), ab18a03s00.getT03DescEu(),
				ab18a03s00.getT03IdAplicacion());
		return ab18a03s00;
	}

	/**
	 * Finds a single row in the Ab18a03s00 table.
	 * 
	 * @param aplicacionInvocante
	 *            Ab18aAplicacionInvocante
	 * @return Ab18aAplicacionInvocante
	 */
	@Transactional(readOnly = true)
	public Ab18aAplicacionInvocante find(Ab18aAplicacionInvocante aplicacionInvocante) {
		String query = "SELECT t1.T03_ID_APLICACION T03IDAPLICACION, t1.T03_MODO_RECEPCION T03MODORECEPCION, t1.T03_DESC_ES T03DESCES, t1.T03_DESC_EU T03DESCEU FROM AB18A03S00 t1  WHERE t1.T03_ID_APLICACION = ?  ";

		List<Object> params = new ArrayList<Object>();
		params.add(aplicacionInvocante.getT03IdAplicacion());
		List<Ab18aAplicacionInvocante> aplicacionInvocanteList = this.jdbcTemplate.query(query, this.rwMap, params.toArray());
		return (Ab18aAplicacionInvocante) DataAccessUtils.uniqueResult(aplicacionInvocanteList);
	}

	/**
	 * Removes a single row in the Ab18a03s00 table.
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00
	 * @return
	 */
	public void remove(Ab18aAplicacionInvocante ab18a03s00) {
		String query = "DELETE FROM AB18A03S00 WHERE T03_ID_APLICACION=?";
		this.jdbcTemplate.update(query, ab18a03s00.getT03IdAplicacion());
	}

	/**
	 * Finds a list of rows in the Ab18a03s00 table.
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a03s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aAplicacionInvocante> findAll(Ab18aAplicacionInvocante ab18a03s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T03_ID_APLICACION T03IDAPLICACION,t1.T03_MODO_RECEPCION T03MODORECEPCION,t1.T03_DESC_ES T03DESCES,t1.T03_DESC_EU T03DESCEU ");
		query.append("FROM AB18A03S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a03s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aAplicacionInvocante>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a03s00 table using like.
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a03s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aAplicacionInvocante> findAllLike(Ab18aAplicacionInvocante ab18a03s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T03_ID_APLICACION T03IDAPLICACION,t1.T03_MODO_RECEPCION T03MODORECEPCION,t1.T03_DESC_ES T03DESCES,t1.T03_DESC_EU T03DESCEU ");
		query.append("FROM AB18A03S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a03s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aAplicacionInvocante>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a03s00 table.
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aAplicacionInvocante ab18a03s00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A03S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a03s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Ab18a03s00 table using like.
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aAplicacionInvocante ab18a03s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A03S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a03s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a03s00 selected for rup_table
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a03s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aAplicacionInvocante>> reorderSelection(Ab18aAplicacionInvocante ab18a03s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T03_ID_APLICACION T03IDAPLICACION,t1.T03_MODO_RECEPCION T03MODORECEPCION,t1.T03_DESC_ES T03DESCES,t1.T03_DESC_EU T03DESCEU ");
		// FROM
		query.append("FROM AB18A03S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a03s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(query, jqGridRequestDto, Ab18aAplicacionInvocante.class, filterParamList,
				"T03_ID_APLICACION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aAplicacionInvocante>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a03s00
	 * @param searchParams
	 *            Ab18a03s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a03s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aAplicacionInvocante>> search(Ab18aAplicacionInvocante filterParams, Ab18aAplicacionInvocante searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T03_ID_APLICACION T03IDAPLICACION,t1.T03_MODO_RECEPCION T03MODORECEPCION,t1.T03_DESC_ES T03DESCES,t1.T03_DESC_EU T03DESCEU ");
		// FROM
		query.append("FROM AB18A03S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Ab18aAplicacionInvocante.class, filterParamList,
				searchSQL, searchParamList, from_alias, "T03_ID_APLICACION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aAplicacionInvocante>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a03s00
	 *            Ab18a03s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aAplicacionInvocante filterab18a03s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T03_ID_APLICACION T03IDAPLICACION,t1.T03_MODO_RECEPCION T03MODORECEPCION,t1.T03_DESC_ES T03DESCES,t1.T03_DESC_EU T03DESCEU ");
		// FROM
		query.append("FROM AB18A03S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a03s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Ab18aAplicacionInvocante.class, query, params,
				"T03_ID_APLICACION");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a03s00 table.
	 * 
	 * @param filterAb18a03s00
	 *            Ab18a03s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a03s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aAplicacionInvocante>> findAllLikeJerarquia(Ab18aAplicacionInvocante filterAb18a03s00,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T03_ID_APLICACION T03IDAPLICACION,t1.T03_MODO_RECEPCION T03MODORECEPCION,t1.T03_DESC_ES T03DESCES,t1.T03_DESC_EU T03DESCEU ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A03S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A03S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a03s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "T03_ID_APLICACION", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a03s00
	 *            Ab18a03s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aAplicacionInvocante filterAb18a03s00, JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A03S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A03S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a03s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "T03_ID_APLICACION", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a03s00
	 *            Ab18a03s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a03s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aAplicacionInvocante>> findAllChild(Ab18aAplicacionInvocante filterAb18a03s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A03S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A03S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a03s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "T03_ID_APLICACION", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Ab18aAplicacionInvocante>(this.rwMapPK, "T03_ID_APLICACION"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a03s00 entity
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aAplicacionInvocante ab18a03s00) {

		StringBuilder where = new StringBuilder(Ab18aAplicacionInvocanteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (Utilidades.notNullAndNotZero(ab18a03s00.getT03IdAplicacion())) {
			where.append(" AND t1.T03_ID_APLICACION = ?");
			params.add(ab18a03s00.getT03IdAplicacion());
		}
		if (Utilidades.notNullAndNotZero(ab18a03s00.getT03ModoRecepcion())) {
			where.append(" AND t1.T03_MODO_RECEPCION = ?");
			params.add(ab18a03s00.getT03ModoRecepcion());
		}
		if (Utilidades.notNullAndNotEmpty(ab18a03s00.getT03DescEs())) {
			where.append(" AND t1.T03_DESC_ES = ?");
			params.add(ab18a03s00.getT03DescEs());
		}
		if (Utilidades.notNullAndNotEmpty(ab18a03s00.getT03DescEu())) {
			where.append(" AND t1.T03_DESC_EU = ?");
			params.add(ab18a03s00.getT03DescEu());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a03s00 entity
	 * 
	 * @param ab18a03s00
	 *            Ab18a03s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aAplicacionInvocante ab18a03s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(Ab18aAplicacionInvocanteDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a03s00 != null && Utilidades.notNullAndNotEmpty(ab18a03s00.getT03IdAplicacion())) {
			where.append(" AND t1.T03_ID_APLICACION = ?");
			params.add(ab18a03s00.getT03IdAplicacion());
		}
		if (ab18a03s00 != null && Utilidades.notNullAndNotEmpty(ab18a03s00.getT03ModoRecepcion())) {
			where.append(" AND t1.T03_MODO_RECEPCION = ?");
			params.add(ab18a03s00.getT03ModoRecepcion());
		}
		if (ab18a03s00 != null && Utilidades.notNullAndNotEmpty(ab18a03s00.getT03DescEs())) {
			where.append(" AND UPPER(t1.T03_DESC_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a03s00.getT03DescEs().toUpperCase() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(ab18a03s00.getT03DescEs().toUpperCase()) + "%");
			}
			where.append(" AND t1.T03_DESC_ES IS NOT NULL");
		}
		if (ab18a03s00 != null && Utilidades.notNullAndNotEmpty(ab18a03s00.getT03DescEu())) {
			where.append(" AND UPPER(t1.T03_DESC_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a03s00.getT03DescEu().toUpperCase() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(ab18a03s00.getT03DescEu().toUpperCase()) + "%");
			}
			where.append(" AND t1.T03_DESC_EU IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
